﻿using System;
using System.Web;
using VIRP_WEB.BaseCode;
using VIRP.EFR.BLL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class Default : EfrBasePage
    {
        private const string EFR = "Embedded Fragment Registry";

        //private readonly EfrStatistics efrStatistics;

        public Default()
        {
            //efrStatistics = new EfrStatistics();
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle("Welcome to the Embedded Fragment Registry.");

            if (UserSession == null || !UserSession.CurrentRegistry.Equals(EFR, StringComparison.OrdinalIgnoreCase))
                Response.Redirect("~/Default.aspx", false);

            if (!IsPostBack)
            {
                //gvCountStatistics.DataSource = efrStatistics.GetEfrCountStatistics();
                gvCountStatistics.DataSource = REFERRALManager.GetEfrCountStatistics(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                gvCountStatistics.DataBind();
                gvCountStatistics.Caption = "";
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + gvCountStatistics.ClientID + "');", true);
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + gvDateStatistics.ClientID + "');", true);
        }
    }
}